﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace SID_monitor
{
    public partial class PanelChannels : UserControl
    {
        string[] COMPortsList;

        public PanelChannels()
        {
            InitializeComponent();

            COMPortsList = System.IO.Ports.SerialPort.GetPortNames();

            #region checkbox initialisation and other controls enabling
            this.checkBox_channel1.Checked = SID_monitor.Properties.Settings.Default.Channel1Active;
            this.checkBox_channel2.Checked = SID_monitor.Properties.Settings.Default.Channel2Active;
            this.checkBox_channel3.Checked = SID_monitor.Properties.Settings.Default.Channel3Active;
            this.checkBox_channel4.Checked = SID_monitor.Properties.Settings.Default.Channel4Active;
            this.checkBox_channel5.Checked = SID_monitor.Properties.Settings.Default.Channel5Active;
            this.checkBox_channel6.Checked = SID_monitor.Properties.Settings.Default.Channel6Active;
            this.checkBox_channel7.Checked = SID_monitor.Properties.Settings.Default.Channel7Active;
            this.checkBox_channel8.Checked = SID_monitor.Properties.Settings.Default.Channel8Active;
            this.checkBox_channel9.Checked = SID_monitor.Properties.Settings.Default.Channel9Active;
            this.checkBox_channel10.Checked = SID_monitor.Properties.Settings.Default.Channel10Active;
            this.checkBox_channel11.Checked = SID_monitor.Properties.Settings.Default.Channel11Active;
            this.checkBox_channel12.Checked = SID_monitor.Properties.Settings.Default.Channel12Active;
            this.checkBox_channel13.Checked = SID_monitor.Properties.Settings.Default.Channel13Active;
            this.checkBox_channel14.Checked = SID_monitor.Properties.Settings.Default.Channel14Active;
            this.checkBox_channel15.Checked = SID_monitor.Properties.Settings.Default.Channel15Active;
            this.checkBox_channel16.Checked = SID_monitor.Properties.Settings.Default.Channel16Active;

            this.comboBox_channel1.Enabled = this.checkBox_channel1.Checked;
            this.comboBox_channel2.Enabled = this.checkBox_channel2.Checked;
            this.comboBox_channel3.Enabled = this.checkBox_channel3.Checked;
            this.comboBox_channel4.Enabled = this.checkBox_channel4.Checked;
            this.comboBox_channel5.Enabled = this.checkBox_channel5.Checked;
            this.comboBox_channel6.Enabled = this.checkBox_channel6.Checked;
            this.comboBox_channel7.Enabled = this.checkBox_channel7.Checked;
            this.comboBox_channel8.Enabled = this.checkBox_channel8.Checked;
            this.comboBox_channel9.Enabled = this.checkBox_channel9.Checked;
            this.comboBox_channel10.Enabled = this.checkBox_channel10.Checked;
            this.comboBox_channel11.Enabled = this.checkBox_channel11.Checked;
            this.comboBox_channel12.Enabled = this.checkBox_channel12.Checked;
            this.comboBox_channel13.Enabled = this.checkBox_channel13.Checked;
            this.comboBox_channel14.Enabled = this.checkBox_channel14.Checked;
            this.comboBox_channel15.Enabled = this.checkBox_channel15.Checked;
            this.comboBox_channel16.Enabled = this.checkBox_channel16.Checked;

            this.textBox1.Enabled = this.checkBox_channel1.Checked;
            this.textBox2.Enabled = this.checkBox_channel2.Checked;
            this.textBox3.Enabled = this.checkBox_channel3.Checked;
            this.textBox4.Enabled = this.checkBox_channel4.Checked;
            this.textBox5.Enabled = this.checkBox_channel5.Checked;
            this.textBox6.Enabled = this.checkBox_channel6.Checked;
            this.textBox7.Enabled = this.checkBox_channel7.Checked;
            this.textBox8.Enabled = this.checkBox_channel8.Checked;
            this.textBox9.Enabled = this.checkBox_channel9.Checked;
            this.textBox10.Enabled = this.checkBox_channel10.Checked;
            this.textBox11.Enabled = this.checkBox_channel11.Checked;
            this.textBox12.Enabled = this.checkBox_channel12.Checked;
            this.textBox13.Enabled = this.checkBox_channel13.Checked;
            this.textBox14.Enabled = this.checkBox_channel14.Checked;
            this.textBox15.Enabled = this.checkBox_channel15.Checked;
            this.textBox16.Enabled = this.checkBox_channel16.Checked;

            this.textBoxTitle1.Enabled = this.checkBox_channel1.Checked;
            this.textBoxTitle2.Enabled = this.checkBox_channel2.Checked;
            this.textBoxTitle3.Enabled = this.checkBox_channel3.Checked;
            this.textBoxTitle4.Enabled = this.checkBox_channel4.Checked;
            this.textBoxTitle5.Enabled = this.checkBox_channel5.Checked;
            this.textBoxTitle6.Enabled = this.checkBox_channel6.Checked;
            this.textBoxTitle7.Enabled = this.checkBox_channel7.Checked;
            this.textBoxTitle8.Enabled = this.checkBox_channel8.Checked;
            this.textBoxTitle9.Enabled = this.checkBox_channel9.Checked;
            this.textBoxTitle10.Enabled = this.checkBox_channel10.Checked;
            this.textBoxTitle11.Enabled = this.checkBox_channel11.Checked;
            this.textBoxTitle12.Enabled = this.checkBox_channel12.Checked;
            this.textBoxTitle13.Enabled = this.checkBox_channel13.Checked;
            this.textBoxTitle14.Enabled = this.checkBox_channel14.Checked;
            this.textBoxTitle15.Enabled = this.checkBox_channel15.Checked;
            this.textBoxTitle16.Enabled = this.checkBox_channel16.Checked;

            this.comboBoxLineWidth1.Enabled = this.checkBox_channel1.Checked;
            this.comboBoxLineWidth2.Enabled = this.checkBox_channel2.Checked;
            this.comboBoxLineWidth3.Enabled = this.checkBox_channel3.Checked;
            this.comboBoxLineWidth4.Enabled = this.checkBox_channel4.Checked;
            this.comboBoxLineWidth5.Enabled = this.checkBox_channel5.Checked;
            this.comboBoxLineWidth6.Enabled = this.checkBox_channel6.Checked;
            this.comboBoxLineWidth7.Enabled = this.checkBox_channel7.Checked;
            this.comboBoxLineWidth8.Enabled = this.checkBox_channel8.Checked;
            this.comboBoxLineWidth9.Enabled = this.checkBox_channel9.Checked;
            this.comboBoxLineWidth10.Enabled = this.checkBox_channel10.Checked;
            this.comboBoxLineWidth11.Enabled = this.checkBox_channel11.Checked;
            this.comboBoxLineWidth12.Enabled = this.checkBox_channel12.Checked;
            this.comboBoxLineWidth13.Enabled = this.checkBox_channel13.Checked;
            this.comboBoxLineWidth14.Enabled = this.checkBox_channel14.Checked;
            this.comboBoxLineWidth15.Enabled = this.checkBox_channel15.Checked;
            this.comboBoxLineWidth16.Enabled = this.checkBox_channel16.Checked;
            this.comboBoxLineWidth1_TextChanged(this.comboBoxLineWidth1, EventArgs.Empty);
            this.comboBoxLineWidth2_TextChanged(this.comboBoxLineWidth2, EventArgs.Empty);
            this.comboBoxLineWidth3_TextChanged(this.comboBoxLineWidth3, EventArgs.Empty);
            this.comboBoxLineWidth4_TextChanged(this.comboBoxLineWidth4, EventArgs.Empty);
            this.comboBoxLineWidth5_TextChanged(this.comboBoxLineWidth5, EventArgs.Empty);
            this.comboBoxLineWidth6_TextChanged(this.comboBoxLineWidth6, EventArgs.Empty);
            this.comboBoxLineWidth7_TextChanged(this.comboBoxLineWidth7, EventArgs.Empty);
            this.comboBoxLineWidth8_TextChanged(this.comboBoxLineWidth8, EventArgs.Empty);
            this.comboBoxLineWidth9_TextChanged(this.comboBoxLineWidth9, EventArgs.Empty);
            this.comboBoxLineWidth10_TextChanged(this.comboBoxLineWidth10, EventArgs.Empty);
            this.comboBoxLineWidth11_TextChanged(this.comboBoxLineWidth11, EventArgs.Empty);
            this.comboBoxLineWidth12_TextChanged(this.comboBoxLineWidth12, EventArgs.Empty);
            this.comboBoxLineWidth13_TextChanged(this.comboBoxLineWidth13, EventArgs.Empty);
            this.comboBoxLineWidth14_TextChanged(this.comboBoxLineWidth14, EventArgs.Empty);
            this.comboBoxLineWidth15_TextChanged(this.comboBoxLineWidth15, EventArgs.Empty);
            this.comboBoxLineWidth16_TextChanged(this.comboBoxLineWidth16, EventArgs.Empty);

            this.colorButtonChannel1.Enabled = this.checkBox_channel1.Checked;
            this.colorButtonChannel2.Enabled = this.checkBox_channel2.Checked;
            this.colorButtonChannel3.Enabled = this.checkBox_channel3.Checked;
            this.colorButtonChannel4.Enabled = this.checkBox_channel4.Checked;
            this.colorButtonChannel5.Enabled = this.checkBox_channel5.Checked;
            this.colorButtonChannel6.Enabled = this.checkBox_channel6.Checked;
            this.colorButtonChannel7.Enabled = this.checkBox_channel7.Checked;
            this.colorButtonChannel8.Enabled = this.checkBox_channel8.Checked;
            this.colorButtonChannel9.Enabled = this.checkBox_channel9.Checked;
            this.colorButtonChannel10.Enabled = this.checkBox_channel10.Checked;
            this.colorButtonChannel11.Enabled = this.checkBox_channel11.Checked;
            this.colorButtonChannel12.Enabled = this.checkBox_channel12.Checked;
            this.colorButtonChannel13.Enabled = this.checkBox_channel13.Checked;
            this.colorButtonChannel14.Enabled = this.checkBox_channel14.Checked;
            this.colorButtonChannel15.Enabled = this.checkBox_channel15.Checked;
            this.colorButtonChannel16.Enabled = this.checkBox_channel16.Checked;
            #endregion

            #region Port selection comboBox initialisation
            this.comboBox_channel1.Items.Clear();
            this.comboBox_channel2.Items.Clear();
            this.comboBox_channel3.Items.Clear();
            this.comboBox_channel4.Items.Clear();
            this.comboBox_channel5.Items.Clear();
            this.comboBox_channel6.Items.Clear();
            this.comboBox_channel7.Items.Clear();
            this.comboBox_channel8.Items.Clear();
            this.comboBox_channel9.Items.Clear();
            this.comboBox_channel10.Items.Clear();
            this.comboBox_channel11.Items.Clear();
            this.comboBox_channel12.Items.Clear();
            this.comboBox_channel13.Items.Clear();
            this.comboBox_channel14.Items.Clear();
            this.comboBox_channel15.Items.Clear();
            this.comboBox_channel16.Items.Clear();
            this.comboBox_channel1.Items.AddRange(COMPortsList);
            this.comboBox_channel2.Items.AddRange(COMPortsList);
            this.comboBox_channel3.Items.AddRange(COMPortsList);
            this.comboBox_channel4.Items.AddRange(COMPortsList);
            this.comboBox_channel5.Items.AddRange(COMPortsList);
            this.comboBox_channel6.Items.AddRange(COMPortsList);
            this.comboBox_channel7.Items.AddRange(COMPortsList);
            this.comboBox_channel8.Items.AddRange(COMPortsList);
            this.comboBox_channel9.Items.AddRange(COMPortsList);
            this.comboBox_channel10.Items.AddRange(COMPortsList);
            this.comboBox_channel11.Items.AddRange(COMPortsList);
            this.comboBox_channel12.Items.AddRange(COMPortsList);
            this.comboBox_channel13.Items.AddRange(COMPortsList);
            this.comboBox_channel14.Items.AddRange(COMPortsList);
            this.comboBox_channel15.Items.AddRange(COMPortsList);
            this.comboBox_channel16.Items.AddRange(COMPortsList);

            this.comboBox_channel1.Text = SID_monitor.Properties.Settings.Default.Channel1Port;
            this.comboBox_channel2.Text = SID_monitor.Properties.Settings.Default.Channel2Port;
            this.comboBox_channel3.Text = SID_monitor.Properties.Settings.Default.Channel3Port;
            this.comboBox_channel4.Text = SID_monitor.Properties.Settings.Default.Channel4Port;
            this.comboBox_channel5.Text = SID_monitor.Properties.Settings.Default.Channel5Port;
            this.comboBox_channel6.Text = SID_monitor.Properties.Settings.Default.Channel6Port;
            this.comboBox_channel7.Text = SID_monitor.Properties.Settings.Default.Channel7Port;
            this.comboBox_channel8.Text = SID_monitor.Properties.Settings.Default.Channel8Port;
            this.comboBox_channel9.Text = SID_monitor.Properties.Settings.Default.Channel9Port;
            this.comboBox_channel10.Text = SID_monitor.Properties.Settings.Default.Channel10Port;
            this.comboBox_channel11.Text = SID_monitor.Properties.Settings.Default.Channel11Port;
            this.comboBox_channel12.Text = SID_monitor.Properties.Settings.Default.Channel12Port;
            this.comboBox_channel13.Text = SID_monitor.Properties.Settings.Default.Channel13Port;
            this.comboBox_channel14.Text = SID_monitor.Properties.Settings.Default.Channel14Port;
            this.comboBox_channel15.Text = SID_monitor.Properties.Settings.Default.Channel15Port;
            this.comboBox_channel16.Text = SID_monitor.Properties.Settings.Default.Channel16Port;
            #endregion

            #region Station Code textBox initialisation
            this.textBox1.Text = SID_monitor.Properties.Settings.Default.Channel1StationCode;
            this.textBox2.Text = SID_monitor.Properties.Settings.Default.Channel2StationCode;
            this.textBox3.Text = SID_monitor.Properties.Settings.Default.Channel3StationCode;
            this.textBox4.Text = SID_monitor.Properties.Settings.Default.Channel4StationCode;
            this.textBox5.Text = SID_monitor.Properties.Settings.Default.Channel5StationCode;
            this.textBox6.Text = SID_monitor.Properties.Settings.Default.Channel6StationCode;
            this.textBox7.Text = SID_monitor.Properties.Settings.Default.Channel7StationCode;
            this.textBox8.Text = SID_monitor.Properties.Settings.Default.Channel8StationCode;
            this.textBox9.Text = SID_monitor.Properties.Settings.Default.Channel9StationCode;
            this.textBox10.Text = SID_monitor.Properties.Settings.Default.Channel10StationCode;
            this.textBox11.Text = SID_monitor.Properties.Settings.Default.Channel11StationCode;
            this.textBox12.Text = SID_monitor.Properties.Settings.Default.Channel12StationCode;
            this.textBox13.Text = SID_monitor.Properties.Settings.Default.Channel13StationCode;
            this.textBox14.Text = SID_monitor.Properties.Settings.Default.Channel14StationCode;
            this.textBox15.Text = SID_monitor.Properties.Settings.Default.Channel15StationCode;
            this.textBox16.Text = SID_monitor.Properties.Settings.Default.Channel16StationCode;
            #endregion

            #region Title textBox initialisation
            this.textBoxTitle1.Text = SID_monitor.Properties.Settings.Default.Channel1Title;
            this.textBoxTitle2.Text = SID_monitor.Properties.Settings.Default.Channel2Title;
            this.textBoxTitle3.Text = SID_monitor.Properties.Settings.Default.Channel3Title;
            this.textBoxTitle4.Text = SID_monitor.Properties.Settings.Default.Channel4Title;
            this.textBoxTitle5.Text = SID_monitor.Properties.Settings.Default.Channel5Title;
            this.textBoxTitle6.Text = SID_monitor.Properties.Settings.Default.Channel6Title;
            this.textBoxTitle7.Text = SID_monitor.Properties.Settings.Default.Channel7Title;
            this.textBoxTitle8.Text = SID_monitor.Properties.Settings.Default.Channel8Title;
            this.textBoxTitle9.Text = SID_monitor.Properties.Settings.Default.Channel9Title;
            this.textBoxTitle10.Text = SID_monitor.Properties.Settings.Default.Channel10Title;
            this.textBoxTitle11.Text = SID_monitor.Properties.Settings.Default.Channel11Title;
            this.textBoxTitle12.Text = SID_monitor.Properties.Settings.Default.Channel12Title;
            this.textBoxTitle13.Text = SID_monitor.Properties.Settings.Default.Channel13Title;
            this.textBoxTitle14.Text = SID_monitor.Properties.Settings.Default.Channel14Title;
            this.textBoxTitle15.Text = SID_monitor.Properties.Settings.Default.Channel15Title;
            this.textBoxTitle16.Text = SID_monitor.Properties.Settings.Default.Channel16Title;
            this.textBoxTitleGOES10.Text = SID_monitor.Properties.Settings.Default.GOES10Title;
            this.textBoxTitleGOES11.Text = SID_monitor.Properties.Settings.Default.GOES11Title;
            this.textBoxTitleGOES12.Text = SID_monitor.Properties.Settings.Default.GOES12Title;
            #endregion

            #region Line width Combobox  initialisation
            this.comboBoxLineWidth1.Text = SID_monitor.Properties.Settings.Default.Channel1LineWidth;
            this.comboBoxLineWidth2.Text = SID_monitor.Properties.Settings.Default.Channel2LineWidth;
            this.comboBoxLineWidth3.Text = SID_monitor.Properties.Settings.Default.Channel3LineWidth;
            this.comboBoxLineWidth4.Text = SID_monitor.Properties.Settings.Default.Channel4LineWidth;
            this.comboBoxLineWidth5.Text = SID_monitor.Properties.Settings.Default.Channel5LineWidth;
            this.comboBoxLineWidth6.Text = SID_monitor.Properties.Settings.Default.Channel6LineWidth;
            this.comboBoxLineWidth7.Text = SID_monitor.Properties.Settings.Default.Channel7LineWidth;
            this.comboBoxLineWidth8.Text = SID_monitor.Properties.Settings.Default.Channel8LineWidth;
            this.comboBoxLineWidth9.Text = SID_monitor.Properties.Settings.Default.Channel9LineWidth;
            this.comboBoxLineWidth10.Text = SID_monitor.Properties.Settings.Default.Channel10LineWidth;
            this.comboBoxLineWidth11.Text = SID_monitor.Properties.Settings.Default.Channel11LineWidth;
            this.comboBoxLineWidth12.Text = SID_monitor.Properties.Settings.Default.Channel12LineWidth;
            this.comboBoxLineWidth13.Text = SID_monitor.Properties.Settings.Default.Channel13LineWidth;
            this.comboBoxLineWidth14.Text = SID_monitor.Properties.Settings.Default.Channel14LineWidth;
            this.comboBoxLineWidth15.Text = SID_monitor.Properties.Settings.Default.Channel15LineWidth;
            this.comboBoxLineWidth16.Text = SID_monitor.Properties.Settings.Default.Channel16LineWidth;
            this.comboBoxLineWidthGOES10.Text = SID_monitor.Properties.Settings.Default.GOES10LineWidth;
            this.comboBoxLineWidthGOES11.Text = SID_monitor.Properties.Settings.Default.GOES11LineWidth;
            this.comboBoxLineWidthGOES12.Text = SID_monitor.Properties.Settings.Default.GOES12LineWidth;
            #endregion

            #region color selection ColorButton initialisation
            this.colorButtonChannel1.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel1LineColor);
            this.colorButtonChannel2.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel2LineColor);
            this.colorButtonChannel3.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel3LineColor);
            this.colorButtonChannel4.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel4LineColor);
            this.colorButtonChannel5.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel5LineColor);
            this.colorButtonChannel6.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel6LineColor);
            this.colorButtonChannel7.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel7LineColor);
            this.colorButtonChannel8.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel8LineColor);
            this.colorButtonChannel9.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel9LineColor);
            this.colorButtonChannel10.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel10LineColor);
            this.colorButtonChannel11.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel11LineColor);
            this.colorButtonChannel12.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel12LineColor);
            this.colorButtonChannel13.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel13LineColor);
            this.colorButtonChannel14.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel14LineColor);
            this.colorButtonChannel15.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel15LineColor);
            this.colorButtonChannel16.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.Channel16LineColor);
            this.colorButtonGOES10.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.GOES10LineColor);
            this.colorButtonGOES11.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.GOES11LineColor);
            this.colorButtonGOES12.CenterColor = Color.FromArgb(SID_monitor.Properties.Settings.Default.GOES12LineColor);
            #endregion


        }

        void ColorButton_Click(object sender, System.EventArgs e)
        {
            ColorButton callingButton = (ColorButton)sender;
            Point p = new Point(callingButton.Left, callingButton.Top + callingButton.Height);
            p = PointToScreen(p);

            ColorPaletteDialog clDlg = new ColorPaletteDialog(p.X, p.Y);

            clDlg.ShowDialog();

            if (clDlg.DialogResult == DialogResult.OK)
            {
                callingButton.CenterColor = clDlg.Color;
            }

            Invalidate();

            clDlg.Dispose();
        }



        #region Checkboxes CheckedChanged Event Handlers
        private void checkBox_channel1_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel1.Enabled = this.checkBox_channel1.Checked;
            this.textBox1.Enabled = this.checkBox_channel1.Checked;
            this.textBoxTitle1.Enabled = this.checkBox_channel1.Checked;
            this.comboBoxLineWidth1.Enabled = this.checkBox_channel1.Checked;
            this.colorButtonChannel1.Enabled = this.checkBox_channel1.Checked;
        }

        private void checkBox_channel2_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel2.Enabled = this.checkBox_channel2.Checked;
            this.textBox2.Enabled = this.checkBox_channel2.Checked;
            this.textBoxTitle2.Enabled = this.checkBox_channel2.Checked;
            this.comboBoxLineWidth2.Enabled = this.checkBox_channel2.Checked;
            this.colorButtonChannel2.Enabled = this.checkBox_channel2.Checked;
        }

        private void checkBox_channel3_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel3.Enabled = this.checkBox_channel3.Checked;
            this.textBox3.Enabled = this.checkBox_channel3.Checked;
            this.textBoxTitle3.Enabled = this.checkBox_channel3.Checked;
            this.comboBoxLineWidth3.Enabled = this.checkBox_channel3.Checked;
            this.colorButtonChannel3.Enabled = this.checkBox_channel3.Checked;
        }

        private void checkBox_channel4_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel4.Enabled = this.checkBox_channel4.Checked;
            this.textBox4.Enabled = this.checkBox_channel4.Checked;
            this.textBoxTitle4.Enabled = this.checkBox_channel4.Checked;
            this.comboBoxLineWidth4.Enabled = this.checkBox_channel4.Checked;
            this.colorButtonChannel4.Enabled = this.checkBox_channel4.Checked;
        }

        private void checkBox_channel5_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel5.Enabled = this.checkBox_channel5.Checked;
            this.textBox5.Enabled = this.checkBox_channel5.Checked;
            this.textBoxTitle5.Enabled = this.checkBox_channel5.Checked;
            this.comboBoxLineWidth5.Enabled = this.checkBox_channel5.Checked;
            this.colorButtonChannel5.Enabled = this.checkBox_channel5.Checked;
        }

        private void checkBox_channel6_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel6.Enabled = this.checkBox_channel6.Checked;
            this.textBox6.Enabled = this.checkBox_channel6.Checked;
            this.textBoxTitle6.Enabled = this.checkBox_channel6.Checked;
            this.comboBoxLineWidth6.Enabled = this.checkBox_channel6.Checked;
            this.colorButtonChannel6.Enabled = this.checkBox_channel6.Checked;
        }

        private void checkBox_channel7_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel7.Enabled = this.checkBox_channel7.Checked;
            this.textBox7.Enabled = this.checkBox_channel7.Checked;
            this.textBoxTitle7.Enabled = this.checkBox_channel7.Checked;
            this.comboBoxLineWidth7.Enabled = this.checkBox_channel7.Checked;
            this.colorButtonChannel7.Enabled = this.checkBox_channel7.Checked;
        }

        private void checkBox_channel8_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel8.Enabled = this.checkBox_channel8.Checked;
            this.textBox8.Enabled = this.checkBox_channel8.Checked;
            this.textBoxTitle8.Enabled = this.checkBox_channel8.Checked;
            this.comboBoxLineWidth8.Enabled = this.checkBox_channel8.Checked;
            this.colorButtonChannel8.Enabled = this.checkBox_channel8.Checked;
        }

        private void checkBox_channel9_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel9.Enabled = this.checkBox_channel9.Checked;
            this.textBox9.Enabled = this.checkBox_channel9.Checked;
            this.textBoxTitle9.Enabled = this.checkBox_channel9.Checked;
            this.comboBoxLineWidth9.Enabled = this.checkBox_channel9.Checked;
            this.colorButtonChannel9.Enabled = this.checkBox_channel9.Checked;
        }

        private void checkBox_channel10_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel10.Enabled = this.checkBox_channel10.Checked;
            this.textBox10.Enabled = this.checkBox_channel10.Checked;
            this.textBoxTitle10.Enabled = this.checkBox_channel10.Checked;
            this.comboBoxLineWidth10.Enabled = this.checkBox_channel10.Checked;
            this.colorButtonChannel10.Enabled = this.checkBox_channel10.Checked;
        }

        private void checkBox_channel11_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel11.Enabled = this.checkBox_channel11.Checked;
            this.textBox11.Enabled = this.checkBox_channel11.Checked;
            this.textBoxTitle11.Enabled = this.checkBox_channel11.Checked;
            this.comboBoxLineWidth11.Enabled = this.checkBox_channel11.Checked;
            this.colorButtonChannel11.Enabled = this.checkBox_channel11.Checked;
        }

        private void checkBox_channel12_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel12.Enabled = this.checkBox_channel12.Checked;
            this.textBox12.Enabled = this.checkBox_channel12.Checked;
            this.textBoxTitle12.Enabled = this.checkBox_channel12.Checked;
            this.comboBoxLineWidth12.Enabled = this.checkBox_channel12.Checked;
            this.colorButtonChannel12.Enabled = this.checkBox_channel12.Checked;
        }

        private void checkBox_channel13_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel13.Enabled = this.checkBox_channel13.Checked;
            this.textBox13.Enabled = this.checkBox_channel13.Checked;
            this.textBoxTitle13.Enabled = this.checkBox_channel13.Checked;
            this.comboBoxLineWidth13.Enabled = this.checkBox_channel13.Checked;
            this.colorButtonChannel13.Enabled = this.checkBox_channel13.Checked;
        }

        private void checkBox_channel14_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel14.Enabled = this.checkBox_channel14.Checked;
            this.textBox14.Enabled = this.checkBox_channel14.Checked;
            this.textBoxTitle14.Enabled = this.checkBox_channel14.Checked;
            this.comboBoxLineWidth14.Enabled = this.checkBox_channel14.Checked;
            this.colorButtonChannel14.Enabled = this.checkBox_channel14.Checked;
        }

        private void checkBox_channel15_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel15.Enabled = this.checkBox_channel15.Checked;
            this.textBox15.Enabled = this.checkBox_channel15.Checked;
            this.textBoxTitle15.Enabled = this.checkBox_channel15.Checked;
            this.comboBoxLineWidth15.Enabled = this.checkBox_channel15.Checked;
            this.colorButtonChannel15.Enabled = this.checkBox_channel15.Checked;
        }

        private void checkBox_channel16_CheckedChanged(object sender, EventArgs e)
        {
            this.comboBox_channel16.Enabled = this.checkBox_channel16.Checked;
            this.textBox16.Enabled = this.checkBox_channel16.Checked;
            this.textBoxTitle16.Enabled = this.checkBox_channel16.Checked;
            this.comboBoxLineWidth16.Enabled = this.checkBox_channel16.Checked;
            this.colorButtonChannel16.Enabled = this.checkBox_channel16.Checked;
        }
        #endregion

        #region Channel Active Properties
        public bool Channel1Active
        {
            get
            {
                return this.checkBox_channel1.Checked;
            }
        }

        public bool Channel2Active
        {
            get
            {
                return this.checkBox_channel2.Checked;
            }
        }

        public bool Channel3Active
        {
            get
            {
                return this.checkBox_channel3.Checked;
            }
        }

        public bool Channel4Active
        {
            get
            {
                return this.checkBox_channel4.Checked;
            }
        }

        public bool Channel5Active
        {
            get
            {
                return this.checkBox_channel5.Checked;
            }
        }

        public bool Channel6Active
        {
            get
            {
                return this.checkBox_channel6.Checked;
            }
        }

        public bool Channel7Active
        {
            get
            {
                return this.checkBox_channel7.Checked;
            }
        }

        public bool Channel8Active
        {
            get
            {
                return this.checkBox_channel8.Checked;
            }
        }

        public bool Channel9Active
        {
            get
            {
                return this.checkBox_channel9.Checked;
            }
        }

        public bool Channel10Active
        {
            get
            {
                return this.checkBox_channel10.Checked;
            }
        }

        public bool Channel11Active
        {
            get
            {
                return this.checkBox_channel11.Checked;
            }
        }

        public bool Channel12Active
        {
            get
            {
                return this.checkBox_channel12.Checked;
            }
        }

        public bool Channel13Active
        {
            get
            {
                return this.checkBox_channel13.Checked;
            }
        }

        public bool Channel14Active
        {
            get
            {
                return this.checkBox_channel14.Checked;
            }
        }

        public bool Channel15Active
        {
            get
            {
                return this.checkBox_channel15.Checked;
            }
        }

        public bool Channel16Active
        {
            get
            {
                return this.checkBox_channel16.Checked;
            }
        }
        #endregion

        #region Port Properties
        public string Channel1Port
        {
            get
            {
                return this.comboBox_channel1.Text.ToUpperInvariant();
            }
        }

        public string Channel2Port
        {
            get
            {
                return this.comboBox_channel2.Text.ToUpperInvariant();
            }
        }

        public string Channel3Port
        {
            get
            {
                return this.comboBox_channel3.Text.ToUpperInvariant();
            }
        }

        public string Channel4Port
        {
            get
            {
                return this.comboBox_channel4.Text.ToUpperInvariant();
            }
        }

        public string Channel5Port
        {
            get
            {
                return this.comboBox_channel5.Text.ToUpperInvariant();
            }
        }

        public string Channel6Port
        {
            get
            {
                return this.comboBox_channel6.Text.ToUpperInvariant();
            }
        }

        public string Channel7Port
        {
            get
            {
                return this.comboBox_channel7.Text.ToUpperInvariant();
            }
        }

        public string Channel8Port
        {
            get
            {
                return this.comboBox_channel8.Text.ToUpperInvariant();
            }
        }

        public string Channel9Port
        {
            get
            {
                return this.comboBox_channel9.Text.ToUpperInvariant();
            }
        }

        public string Channel10Port
        {
            get
            {
                return this.comboBox_channel10.Text.ToUpperInvariant();
            }
        }

        public string Channel11Port
        {
            get
            {
                return this.comboBox_channel11.Text.ToUpperInvariant();
            }
        }

        public string Channel12Port
        {
            get
            {
                return this.comboBox_channel12.Text.ToUpperInvariant();
            }
        }

        public string Channel13Port
        {
            get
            {
                return this.comboBox_channel13.Text.ToUpperInvariant();
            }
        }

        public string Channel14Port
        {
            get
            {
                return this.comboBox_channel14.Text.ToUpperInvariant();
            }
        }

        public string Channel15Port
        {
            get
            {
                return this.comboBox_channel15.Text.ToUpperInvariant();
            }
        }

        public string Channel16Port
        {
            get
            {
                return this.comboBox_channel16.Text.ToUpperInvariant();
            }
        }
        #endregion

        #region Station Code Properties
        public string Channel1StationCode
        {
            get
            {
                return this.textBox1.Text;
            }
        }

        public string Channel2StationCode
        {
            get
            {
                return this.textBox2.Text;
            }
        }

        public string Channel3StationCode
        {
            get
            {
                return this.textBox3.Text;
            }
        }

        public string Channel4StationCode
        {
            get
            {
                return this.textBox4.Text;
            }
        }

        public string Channel5StationCode
        {
            get
            {
                return this.textBox5.Text;
            }
        }

        public string Channel6StationCode
        {
            get
            {
                return this.textBox6.Text;
            }
        }

        public string Channel7StationCode
        {
            get
            {
                return this.textBox7.Text;
            }
        }

        public string Channel8StationCode
        {
            get
            {
                return this.textBox8.Text;
            }
        }

        public string Channel9StationCode
        {
            get
            {
                return this.textBox9.Text;
            }
        }

        public string Channel10StationCode
        {
            get
            {
                return this.textBox10.Text;
            }
        }

        public string Channel11StationCode
        {
            get
            {
                return this.textBox11.Text;
            }
        }

        public string Channel12StationCode
        {
            get
            {
                return this.textBox12.Text;
            }
        }

        public string Channel13StationCode
        {
            get
            {
                return this.textBox13.Text;
            }
        }

        public string Channel14StationCode
        {
            get
            {
                return this.textBox14.Text;
            }
        }

        public string Channel15StationCode
        {
            get
            {
                return this.textBox15.Text;
            }
        }

        public string Channel16StationCode
        {
            get
            {
                return this.textBox16.Text;
            }
        }
        #endregion

        #region Title Properties
        public string Channel1Title
        {
            get
            {
                return this.textBoxTitle1.Text;
            }
        }

        public string Channel2Title
        {
            get
            {
                return this.textBoxTitle2.Text;
            }
        }

        public string Channel3Title
        {
            get
            {
                return this.textBoxTitle3.Text;
            }
        }

        public string Channel4Title
        {
            get
            {
                return this.textBoxTitle4.Text;
            }
        }

        public string Channel5Title
        {
            get
            {
                return this.textBoxTitle5.Text;
            }
        }

        public string Channel6Title
        {
            get
            {
                return this.textBoxTitle6.Text;
            }
        }

        public string Channel7Title
        {
            get
            {
                return this.textBoxTitle7.Text;
            }
        }

        public string Channel8Title
        {
            get
            {
                return this.textBoxTitle8.Text;
            }
        }

        public string Channel9Title
        {
            get
            {
                return this.textBoxTitle9.Text;
            }
        }

        public string Channel10Title
        {
            get
            {
                return this.textBoxTitle10.Text;
            }
        }

        public string Channel11Title
        {
            get
            {
                return this.textBoxTitle11.Text;
            }
        }

        public string Channel12Title
        {
            get
            {
                return this.textBoxTitle12.Text;
            }
        }

        public string Channel13Title
        {
            get
            {
                return this.textBoxTitle13.Text;
            }
        }

        public string Channel14Title
        {
            get
            {
                return this.textBoxTitle14.Text;
            }
        }

        public string Channel15Title
        {
            get
            {
                return this.textBoxTitle15.Text;
            }
        }

        public string Channel16Title
        {
            get
            {
                return this.textBoxTitle16.Text;
            }
        }

        public string GOES10Title
        {
            get
            {
                return this.textBoxTitleGOES10.Text;
            }
        }

        public string GOES11Title
        {
            get
            {
                return this.textBoxTitleGOES11.Text;
            }
        }
        
        public string GOES12Title
        {
            get
            {
                return this.textBoxTitleGOES12.Text;
            }
        }
        #endregion

        #region LineWidth Properties
        public string Channel1LineWidth
        {
            get
            {
                return this.comboBoxLineWidth1.Text;
            }
        }

        public string Channel2LineWidth
        {
            get
            {
                return this.comboBoxLineWidth2.Text;
            }
        }

        public string Channel3LineWidth
        {
            get
            {
                return this.comboBoxLineWidth3.Text;
            }
        }

        public string Channel4LineWidth
        {
            get
            {
                return this.comboBoxLineWidth4.Text;
            }
        }

        public string Channel5LineWidth
        {
            get
            {
                return this.comboBoxLineWidth5.Text;
            }
        }

        public string Channel6LineWidth
        {
            get
            {
                return this.comboBoxLineWidth6.Text;
            }
        }

        public string Channel7LineWidth
        {
            get
            {
                return this.comboBoxLineWidth7.Text;
            }
        }

        public string Channel8LineWidth
        {
            get
            {
                return this.comboBoxLineWidth8.Text;
            }
        }

        public string Channel9LineWidth
        {
            get
            {
                return this.comboBoxLineWidth9.Text;
            }
        }

        public string Channel10LineWidth
        {
            get
            {
                return this.comboBoxLineWidth10.Text;
            }
        }

        public string Channel11LineWidth
        {
            get
            {
                return this.comboBoxLineWidth11.Text;
            }
        }

        public string Channel12LineWidth
        {
            get
            {
                return this.comboBoxLineWidth12.Text;
            }
        }

        public string Channel13LineWidth
        {
            get
            {
                return this.comboBoxLineWidth13.Text;
            }
        }

        public string Channel14LineWidth
        {
            get
            {
                return this.comboBoxLineWidth14.Text;
            }
        }

        public string Channel15LineWidth
        {
            get
            {
                return this.comboBoxLineWidth15.Text;
            }
        }

        public string Channel16LineWidth
        {
            get
            {
                return this.comboBoxLineWidth16.Text;
            }
        }

        public string GOES10LineWidth
        {
            get
            {
                return this.comboBoxLineWidthGOES10.Text;
            }
        }

        public string GOES11LineWidth
        {
            get
            {
                return this.comboBoxLineWidthGOES11.Text;
            }
        }

        public string GOES12LineWidth
        {
            get
            {
                return this.comboBoxLineWidthGOES12.Text;
            }
        }
        #endregion

        #region LineColor Properties
        public int Channel1LineColor
        {
            get
            {
                return this.colorButtonChannel1.CenterColor.ToArgb();
            }
        }

        public int Channel2LineColor
        {
            get
            {
                return this.colorButtonChannel2.CenterColor.ToArgb();
            }
        }

        public int Channel3LineColor
        {
            get
            {
                return this.colorButtonChannel3.CenterColor.ToArgb();
            }
        }

        public int Channel4LineColor
        {
            get
            {
                return this.colorButtonChannel4.CenterColor.ToArgb();
            }
        }

        public int Channel5LineColor
        {
            get
            {
                return this.colorButtonChannel5.CenterColor.ToArgb();
            }
        }

        public int Channel6LineColor
        {
            get
            {
                return this.colorButtonChannel6.CenterColor.ToArgb();
            }
        }

        public int Channel7LineColor
        {
            get
            {
                return this.colorButtonChannel7.CenterColor.ToArgb();
            }
        }

        public int Channel8LineColor
        {
            get
            {
                return this.colorButtonChannel8.CenterColor.ToArgb();
            }
        }

        public int Channel9LineColor
        {
            get
            {
                return this.colorButtonChannel9.CenterColor.ToArgb();
            }
        }

        public int Channel10LineColor
        {
            get
            {
                return this.colorButtonChannel10.CenterColor.ToArgb();
            }
        }

        public int Channel11LineColor
        {
            get
            {
                return this.colorButtonChannel11.CenterColor.ToArgb();
            }
        }

        public int Channel12LineColor
        {
            get
            {
                return this.colorButtonChannel12.CenterColor.ToArgb();
            }
        }

        public int Channel13LineColor
        {
            get
            {
                return this.colorButtonChannel13.CenterColor.ToArgb();
            }
        }

        public int Channel14LineColor
        {
            get
            {
                return this.colorButtonChannel14.CenterColor.ToArgb();
            }
        }

        public int Channel15LineColor
        {
            get
            {
                return this.colorButtonChannel15.CenterColor.ToArgb();
            }
        }

        public int Channel16LineColor
        {
            get
            {
                return this.colorButtonChannel16.CenterColor.ToArgb();
            }
        }

        public int GOES10LineColor
        {
            get
            {
                return this.colorButtonGOES10.CenterColor.ToArgb();
            }
        }

        public int GOES11LineColor
        {
            get
            {
                return this.colorButtonGOES11.CenterColor.ToArgb();
            }
        }

        public int GOES12LineColor
        {
            get
            {
                return this.colorButtonGOES12.CenterColor.ToArgb();
            }
        }
        #endregion

        #region Values validation Methods

        #region ComboBox Channel Ports
        private void comboBox_channel_CheckForErrors(object sender, EventArgs e)
        {
            ComboBox callingComboBox = (ComboBox)sender;

            if ((callingComboBox.Enabled == false) || (callingComboBox.Items.Contains(callingComboBox.Text.ToUpperInvariant())))
            {
                errorProvider.SetError(callingComboBox, "");
                OnValidData(new validDataEventArgs("NodeChannels", callingComboBox.Handle, true));
            }
            else
            {
                errorProvider.SetError(callingComboBox, "Unknow Serial Port");
                OnValidData(new validDataEventArgs("NodeChannels", callingComboBox.Handle, false));
            }
        }

        #endregion

        #region TextBox StationCode
        /// <summary>
        /// validates the channel station code so that it is compliant with NGCD format
        /// </summary>
        private void textBoxStationCode_CheckForErrors(object sender, EventArgs e)
        {
            TextBox currentTextBox = (TextBox)sender;
            if ((currentTextBox.Enabled == true) && ((currentTextBox.Text.Length == 0) || (currentTextBox.Text.Length > 4) || !Regex.IsMatch(currentTextBox.Text, "[A-Za-z]{2}\\d{2}")))
            {
                errorProvider.SetError(currentTextBox, "Station Code consists of the final two station call letters and of the two numbers which represent the frequency (kHz) rounded to the nearest integer (e.g. NSS at 21.4 kHz is recorded as SS21)");
                OnValidData(new validDataEventArgs("NodeChannels", currentTextBox.Handle, false));
            }
            else
            {
                errorProvider.SetError(currentTextBox, "");
                OnValidData(new validDataEventArgs("NodeChannels", currentTextBox.Handle, true));
            }
        }

        #endregion

        #region TextBox Title
        /// <summary>
        /// validates the channel title so that it is OK for rrdtool dataset name (14 + 5 chars for the station code)
        /// Note: Nothing done because Title no longer used for dataset name. Only station code is used
        /// </summary>
        private void textBoxTitle_CheckForErrors(object sender, EventArgs e)
        {
            //TextBox currentTextBox = (TextBox)sender;
            //if ((currentTextBox.Enabled == true) && ((currentTextBox.Text.Length == 0) || (currentTextBox.Text.Length > 14)))
            //{
            //    errorProvider.SetError(currentTextBox, "Title must be 1 to 14 characters long");
            //    OnValidData(new validDataEventArgs("NodeChannels", currentTextBox.Handle, false));
            //}
            //else
            //{
            //    errorProvider.SetError(currentTextBox, "");
            //    OnValidData(new validDataEventArgs("NodeChannels", currentTextBox.Handle, true));
            //}
        }

        #endregion

        #region ComboBox LineWidth
        private void comboBoxLineWidth_CheckForErrors(object sender, EventArgs e)
        {
            ComboBox callingComboBox = (ComboBox)sender;

            if ((callingComboBox.Enabled == false) || (callingComboBox.Items.Contains(callingComboBox.Text.ToLowerInvariant())))
            {
                errorProvider.SetError(callingComboBox, "");
                OnValidData(new validDataEventArgs("NodeChannels", callingComboBox.Handle, true));
            }
            else
            {
                errorProvider.SetError(callingComboBox, "Unknown Line Width");
                OnValidData(new validDataEventArgs("NodeChannels", callingComboBox.Handle, false));
            }
        }

        private void comboBoxLineWidth1_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel1.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth1.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth1).Equals(String.Empty))
                {
                    this.colorButtonChannel1.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel1.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth2_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel2.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth2.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth2).Equals(String.Empty))
                {
                    this.colorButtonChannel2.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel2.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth3_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel3.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth3.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth3).Equals(String.Empty))
                {
                    this.colorButtonChannel3.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel3.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth4_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel4.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth4.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth4).Equals(String.Empty))
                {
                    this.colorButtonChannel4.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel4.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth5_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel5.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth5.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth5).Equals(String.Empty))
                {
                    this.colorButtonChannel5.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel5.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth6_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel6.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth6.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth6).Equals(String.Empty))
                {
                    this.colorButtonChannel6.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel6.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth7_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel7.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth7.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth7).Equals(String.Empty))
                {
                    this.colorButtonChannel7.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel7.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth8_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel8.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth8.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth8).Equals(String.Empty))
                {
                    this.colorButtonChannel8.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel8.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth9_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel9.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth9.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth9).Equals(String.Empty))
                {
                    this.colorButtonChannel9.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel9.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth10_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel10.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth10.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth10).Equals(String.Empty))
                {
                    this.colorButtonChannel10.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel10.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth11_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel11.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth11.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth11).Equals(String.Empty))
                {
                    this.colorButtonChannel11.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel11.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth12_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel12.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth12.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth12).Equals(String.Empty))
                {
                    this.colorButtonChannel12.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel12.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth13_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel13.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth13.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth13).Equals(String.Empty))
                {
                    this.colorButtonChannel13.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel13.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth14_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel14.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth14.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth14).Equals(String.Empty))
                {
                    this.colorButtonChannel14.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel14.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth15_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel15.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth15.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth15).Equals(String.Empty))
                {
                    this.colorButtonChannel15.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel15.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidth16_TextChanged(object sender, EventArgs e)
        {
            if (this.checkBox_channel16.Checked)
            {
                comboBoxLineWidth_CheckForErrors(sender, e);
                if (comboBoxLineWidth16.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidth16).Equals(String.Empty))
                {
                    this.colorButtonChannel16.Enabled = false;
                }
                else
                {
                    this.colorButtonChannel16.Enabled = true;
                }
            }
        }

        private void comboBoxLineWidthGOES10_TextChanged(object sender, EventArgs e)
        {
            comboBoxLineWidth_CheckForErrors(sender, e);
            if (comboBoxLineWidthGOES10.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidthGOES10).Equals(String.Empty))
            {
                this.colorButtonGOES10.Enabled = false;
            }
            else
            {
                this.colorButtonGOES10.Enabled = true;
            }
        }

        private void comboBoxLineWidthGOES11_TextChanged(object sender, EventArgs e)
        {
            comboBoxLineWidth_CheckForErrors(sender, e);
            if (comboBoxLineWidthGOES11.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidthGOES11).Equals(String.Empty))
            {
                this.colorButtonGOES11.Enabled = false;
            }
            else
            {
                this.colorButtonGOES11.Enabled = true;
            }
        }

        private void comboBoxLineWidthGOES12_TextChanged(object sender, EventArgs e)
        {
            comboBoxLineWidth_CheckForErrors(sender, e);
            if (comboBoxLineWidthGOES12.Text.ToLowerInvariant().Equals("(none)") || !errorProvider.GetError(comboBoxLineWidthGOES12).Equals(String.Empty))
            {
                this.colorButtonGOES12.Enabled = false;
            }
            else
            {
                this.colorButtonGOES12.Enabled = true;
            }
        }
        #endregion

        #endregion

        #region ValidData Event
        public event ValidDataEventHandler ValidData;

        protected virtual void OnValidData(validDataEventArgs e)
        {
            if (ValidData != null)
            {
                // Invokes the delegates. 
                ValidData(this, e);
            }
        }
        #endregion






    }
}
